/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.utils;

import com.flemmli97.improvedmobs.utils.AIUtils;
import com.flemmli97.improvedmobs.utils.ITNTThrowable;
import com.flemmli97.improvedmobs.utils.ItemAI;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemAIs {
    private static final String[] potionEffects = new String[]{"minecraft:regeneration", "minecraft:speed", "minecraft:strength", "minecraft:invisibility", "minecraft:resistance", "minecraft:fire_resistance"};
    public static final ItemAI ENCHANTEDBOOK = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            block7: {
                if (entity.field_70170_p.field_72995_K) break block7;
                List nearby = entity.field_70170_p.func_72839_b((Entity)entity, entity.func_174813_aQ().func_186662_g(8.0));
                List nearTarget = entity.field_70170_p.func_72839_b((Entity)entity.func_70638_az(), entity.func_70638_az().func_174813_aQ().func_186662_g(2.0));
                if (nearby.isEmpty() || nearby.size() == 1 && nearby.get(0) == entity.func_70638_az() || entity.field_70170_p.field_73012_v.nextInt(3) <= 1) {
                    if (nearTarget.isEmpty()) {
                        for (int x = -1; x <= 1; ++x) {
                            for (int z = -1; z <= 1; ++z) {
                                if (x != 0 && z != 0) continue;
                                Vector3d targetMotion = target.func_213322_ci();
                                EvokerFangsEntity fang = new EvokerFangsEntity(entity.field_70170_p, target.func_226277_ct_() + (double)x + targetMotion.field_72450_a, target.func_226278_cu_(), target.func_226281_cx_() + (double)z + targetMotion.field_72449_c, 0.0f, 5, (LivingEntity)entity);
                                entity.field_70170_p.func_217376_c((Entity)fang);
                            }
                        }
                    } else {
                        ShulkerBulletEntity bullet = new ShulkerBulletEntity(entity.field_70170_p, (LivingEntity)entity, (Entity)target, entity.func_174811_aO().func_176740_k());
                        bullet.getPersistentData().func_74757_a("improvedmobs:thrown_entity", true);
                        entity.field_70170_p.func_217376_c((Entity)bullet);
                    }
                } else {
                    for (int i = 0; i < nearby.size(); ++i) {
                        Entity entityRand = (Entity)nearby.get(entity.field_70170_p.field_73012_v.nextInt(nearby.size()));
                        if (!(entityRand instanceof MonsterEntity) || entityRand == entity.func_70638_az()) continue;
                        MonsterEntity mob = (MonsterEntity)entityRand;
                        mob.func_195064_c(new EffectInstance((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionEffects[mob.field_70170_p.field_73012_v.nextInt(6)])), 3600, 1));
                        entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187514_aD, SoundCategory.NEUTRAL, 2.0f, 1.0f);
                        return;
                    }
                }
            }
        }

        @Override
        public int cooldown() {
            return 80;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI TRIDENT = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            AIUtils.tridentAttack(entity, target);
        }

        @Override
        public int cooldown() {
            return 65;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(MobEntity entity, Hand hand) {
            return 40;
        }
    };
    public static final ItemAI TNT = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            double dis = entity.func_213303_ch().func_72438_d(target.func_213303_ch());
            if (!entity.field_70170_p.field_72995_K) {
                TNTEntity tnt = new TNTEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (LivingEntity)entity);
                ((ITNTThrowable)tnt).shootFromEntity((Entity)entity, entity.field_70125_A, entity.field_70177_z, -20.0f, 0.2f + (float)(dis * 0.05), 1.0f);
                tnt.getPersistentData().func_74757_a("improvedmobs:thrown_entity", true);
                entity.field_70170_p.func_217376_c((Entity)tnt);
            }
        }

        @Override
        public int cooldown() {
            return 65;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI FLINT_N_STEEL = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            double dis = entity.func_213303_ch().func_72438_d(target.func_213303_ch());
            if (dis < (double)(entity.func_213311_cf() + target.func_213311_cf()) + 0.5 && !target.func_70027_ad()) {
                target.func_70015_d(4);
            }
        }

        @Override
        public int cooldown() {
            return 25;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI SPLASH = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            if (AIUtils.isBadPotion(stack)) {
                double dis = entity.func_213303_ch().func_72438_d(target.func_213303_ch());
                entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187827_fP, SoundCategory.NEUTRAL, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                if (!entity.field_70170_p.field_72995_K) {
                    PotionEntity potion = new PotionEntity(entity.field_70170_p, (LivingEntity)entity);
                    potion.func_213884_b(stack);
                    potion.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, -30.0f, 0.2f + (float)(dis * 0.05), 1.2f);
                    potion.getPersistentData().func_74757_a("improvedmobs:thrown_entity", true);
                    entity.field_70170_p.func_217376_c((Entity)potion);
                }
            }
        }

        @Override
        public int cooldown() {
            return 85;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean applies(ItemStack stack) {
            return AIUtils.isBadPotion(stack);
        }
    };
    public static final ItemAI LINGERINGPOTIONS = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            if (AIUtils.isBadPotion(stack)) {
                double dis = entity.func_213303_ch().func_72438_d(target.func_213303_ch());
                entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187827_fP, SoundCategory.NEUTRAL, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                if (!entity.field_70170_p.field_72995_K) {
                    PotionEntity potion = new PotionEntity(entity.field_70170_p, (LivingEntity)entity);
                    potion.func_213884_b(stack);
                    potion.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, -30.0f, 0.2f + (float)(dis * 0.05), 1.2f);
                    potion.getPersistentData().func_74757_a("improvedmobs:thrown_entity", true);
                    entity.field_70170_p.func_217376_c((Entity)potion);
                }
            }
        }

        @Override
        public int cooldown() {
            return 85;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean applies(ItemStack stack) {
            return AIUtils.isBadPotion(stack);
        }
    };
    public static final ItemAI CROSSBOWS = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            float vel = CrossbowItem.func_220019_a((ItemStack)stack, (Item)Items.field_196152_dE) ? 1.6f : 3.15f;
            CrossbowItem.func_220014_a((World)entity.field_70170_p, (LivingEntity)entity, (Hand)hand, (ItemStack)stack, (float)vel, (float)1.0f);
            CrossbowItem.func_220011_a((ItemStack)stack, (boolean)false);
        }

        @Override
        public int cooldown() {
            return 20;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STANDING;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(MobEntity entity, Hand hand) {
            return CrossbowItem.func_220026_e((ItemStack)entity.func_184586_b(hand)) + 5;
        }
    };
    public static final ItemAI BOWS = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            AIUtils.attackWithArrows(entity, target, BowItem.func_185059_b((int)entity.func_184612_cw()));
        }

        @Override
        public int cooldown() {
            return 30;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }

        @Override
        public boolean useHand() {
            return true;
        }
    };
    public static final ItemAI SHIELDS = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
        }

        @Override
        public int cooldown() {
            return 60;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.OFF;
        }

        @Override
        public boolean useHand() {
            return true;
        }

        @Override
        public int maxUseCount(MobEntity entity, Hand hand) {
            return 75;
        }

        @Override
        public boolean isIncompatibleWith(LivingEntity entity, ItemStack stack) {
            return stack.func_77973_b() instanceof CrossbowItem || entity instanceof AbstractSkeletonEntity && stack.func_77973_b() instanceof BowItem;
        }
    };
    public static final ItemAI SNOWBALL = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            if (!entity.field_70170_p.field_72995_K) {
                SnowballEntity snowball = new SnowballEntity(entity.field_70170_p, (LivingEntity)entity);
                snowball.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 1.5f, 1.0f);
                snowball.getPersistentData().func_74757_a("improvedmobs:thrown_entity", true);
                entity.field_70170_p.func_217376_c((Entity)snowball);
            }
        }

        @Override
        public int cooldown() {
            return 25;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.STRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI ENDER_PEARL = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            double dis = entity.func_213303_ch().func_72436_e(target.func_213303_ch());
            if (dis > 49.0) {
                entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                if (!entity.field_70170_p.field_72995_K) {
                    Vector3d v1 = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_186678_a(16.0);
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    if (entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72433_c() > 16.0) {
                        x = v1.field_72450_a;
                        y = v1.field_72448_b;
                        z = v1.field_72449_c;
                    }
                    EnderPearlEntity pearl = new EnderPearlEntity(entity.field_70170_p, (LivingEntity)entity);
                    AIUtils.setHeadingToPosition((ThrowableEntity)pearl, target.func_226277_ct_() - x, target.func_226278_cu_() - y, target.func_226281_cx_() - z, 1.5f, 3.0f);
                    entity.field_70170_p.func_217376_c((Entity)pearl);
                }
            }
        }

        @Override
        public int cooldown() {
            return 35;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
    public static final ItemAI LAVABUCKET = new ItemAI(){

        @Override
        public void attack(MobEntity entity, LivingEntity target, Hand hand) {
            double dis = entity.func_213303_ch().func_72438_d(target.func_213303_ch());
            if (dis < 8.0 && AIUtils.tryPlaceLava(entity.field_70170_p, new BlockPos(target.func_226277_ct_() - 2.0 + (double)entity.field_70170_p.field_73012_v.nextInt(4), target.func_226278_cu_() - 1.0 + (double)entity.field_70170_p.field_73012_v.nextInt(2), target.func_226281_cx_() - 2.0 + (double)entity.field_70170_p.field_73012_v.nextInt(4)))) {
                entity.func_195064_c(new EffectInstance(Effects.field_76426_n, 240, 1, true, false));
            }
        }

        @Override
        public int cooldown() {
            return 80;
        }

        @Override
        public ItemAI.ItemType type() {
            return ItemAI.ItemType.NONSTRAFINGITEM;
        }

        @Override
        public ItemAI.UsableHand prefHand() {
            return ItemAI.UsableHand.BOTH;
        }
    };
}

